rm(list = ls(all = TRUE))

 library(akima)
 library(maps)
 library(mapproj)
 library('ncdf')
 source('./function.R')


#prendre en compte les arguments
args<-commandArgs(TRUE)

#attribution des argument aux variables
inputfile<-args[1]
spec<-args[2]
level<-as.integer(args[3])
date<-args[4]
corners_file<-args[5]

#Tests
if (length(args) != 5){
print("Il manque des arguments : ")
print(paste('inputfile ',args[1],sep=""))
print(paste('specie ',args[2],sep=""))
print(paste('level ',args[3],sep=""))
print(paste('date ',args[4],sep=""))
print(paste('corners_file ',args[5],sep=""))
exit
}
#######################################################################
#Donnees pour le graphe
orient_cen=c(45,0)
angle=0
projection="perspective"
orientation=c(orient_cen, angle)
breaks=100
res=100
par=3
fill=FALSE
#figure settings
heights=c(4)
widths=c(4,1)
M.cols=colorRampPalette(c("blue","cyan", "yellow", "red"),space="rgb")
my_col=M.cols(100)
#######################################################################


#Ouverture netcdf
in.file <- open.ncdf(inputfile)
#Variable
lat <- get.var.ncdf(in.file,"lat")
lon <- get.var.ncdf(in.file,"lon")
var <- get.var.ncdf(in.file,spec)
time <- get.var.ncdf(in.file,"Times")
#fermeture
close.ncdf(in.file)

#chercher la date
for(i in seq(from=1,to=dim(time),by=1)){
if(date==substr(time[i],1,13)){
itime<-i
break
}}



#pour le plot
legendlab<-paste(spec,'concentration (ppb)',sep=" ")
outfile <- paste("map_chim_",date,".png", sep="")
titlelab<-paste(substr(time[itime],1,13),sep=" ")

polys<-vector("list",(dim(lon)[1]*dim(lon)[2]))
corner<-read.table(corners_file)
for(i in 1:length(polys)){
s3<-c(corner[i,7],corner[i,4])
s2<-c(corner[i,9],corner[i,6])
s4<-c(corner[i,3],corner[i,8])
s1<-c(corner[i,5],corner[i,10])
polys[[i]] = cbind(c(s4[1], s2[1], s3[1], s1[1]), c(s2[2], s1[2], s4[2], s3[2]))
}
xlim <- range(lon[,], na.rm=TRUE)
ylim <- range(lat[,], na.rm=TRUE)

png(filename = outfile, res=res,width = sum(widths), height = sum(heights), units="in")
 par(omi=c(0.1, 0.1, 0.1, 0.1), ps=12)
 layout(matrix(c(1,2),nrow=1,ncol=2,byrow=TRUE), widths = widths, heights = heights, respect=TRUE)
 colorvalues<-val2col(var[,,level,itime],col=my_col)
 par(mai=c(0.2, 0.2, 0.2, 0.2))
 map("world",projection=projection, orientation=orientation, par=par, fill=fill, xlim=xlim, ylim=ylim)
 for(i in 1:(length(polys))){
  lines(mapproject(x=polys[[i]][,1], y=polys[[i]][,2]), col=colorvalues[i])
  polygon(mapproject(x=polys[[i]][,1], y=polys[[i]][,2]), col=colorvalues[i], border=colorvalues[i])
 }
 map("world", add=TRUE, projection="", par=par, fill=fill, xlim=xlim, ylim=ylim)
 map.grid(c(-180, 180, -80, 80), nx=10, ny=18, labels=FALSE, col="grey")
 title(main=spec)
 box()
 #add scale
 par(mai=c(0.2, 0, 0.2, 0.6))
 image.scale(var[,,level,itime], col=my_col, horiz=FALSE, yaxt="n")
 axis(4,las=1)
 mtext(legendlab, side=4, line=2.5)
 box()
dev.off()
