#!/bin/sh
DOM=CONT6
inputfile=../out.20030804_20030808_CONT6.nc
spec=O3
level='1'
date='2003-08-08_15'
CORNERS_FILE=${DOM}_GRID_CORNERS.data

COORD_DIR=/home/siour/CHIMERE/chimere2011a+/HCOORD
COORD_FILE=${COORD_DIR}/COORD_${DOM}

if [ ! -e ${CORNERS_FILE} ] ; then
   echo "estimation of domain size"
   nzonal=`gawk 'BEGIN{stop=0}{x[FNR]=$1}END{for(k=2;k<=FNR;k++) {if(x[k-1]>x[k]&&stop==0){print k-1;stop=1}}}' ${COORD_FILE}`
   ntotal=`wc -l  ${COORD_FILE} | gawk '{print $1}' `
   nmerid=`expr ${ntotal} /  ${nzonal}`

   echo "  CORNER calculations"
   echo ${nzonal}                                     > calcorners.par 
   echo ${nmerid}                                    >> calcorners.par
   echo ${COORD_FILE}                                >> calcorners.par
   echo ${CORNERS_FILE}                              >> calcorners.par
   ./calcorners.e || { echo "calcorners.e failure"; exit 1; }
   echo "    created file: ${CORNERS_FILE}"
fi

echo "  make map with R"
Rscript map_proj_chim2.R ${inputfile} ${spec} ${level} ${date} ${CORNERS_FILE}
echo "  map with R done"
